<?php 
include "includes/config.php"; 
$pageTitle = "Gallery";
$pageDescription = "View our work and projects in the " . SITE_NAME . " gallery";
include 'includes/header.php'; 
?>
<style>
/* Gallery Section */
.gallery-section {
    padding: 80px 0;
}

.gallery-filters {
    display: flex;
    justify-content: center;
    flex-wrap: wrap;
    gap: 10px;
    margin-bottom: 40px;
}

.filter-btn {
    padding: 8px 20px;
    background-color: var(--light-gray);
    color: var(--dark-color);
    border: none;
    border-radius: 30px;
    cursor: pointer;
    transition: var(--transition);
    font-weight: 500;
}

.filter-btn:hover, .filter-btn.active {
    background-color: var(--primary-color);
    color: var(--white);
}

.gallery-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 20px;
}

.gallery-item {
    position: relative;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    aspect-ratio: 1 / 1;
}

.gallery-item img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: var(--transition);
}

.gallery-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    color: var(--white);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    opacity: 0;
    transition: var(--transition);
    padding: 20px;
    text-align: center;
}

.gallery-overlay h3 {
    font-size: 1.5rem;
    margin-bottom: 10px;
    transform: translateY(20px);
    transition: var(--transition);
}

.gallery-overlay p {
    margin-bottom: 15px;
    transform: translateY(20px);
    transition: var(--transition);
    transition-delay: 0.1s;
}

.gallery-view {
    width: 50px;
    height: 50px;
    background-color: var(--primary-color);
    color: var(--white);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transform: translateY(20px);
    transition: var(--transition);
    transition-delay: 0.2s;
}

.gallery-item:hover .gallery-overlay {
    opacity: 1;
}

.gallery-item:hover .gallery-overlay h3,
.gallery-item:hover .gallery-overlay p,
.gallery-item:hover .gallery-view {
    transform: translateY(0);
}

/* Lightbox Styles */
.lightbox {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.9);
    z-index: 2000;
    justify-content: center;
    align-items: center;
}

.lightbox.active {
    display: flex;
}

.lightbox-content {
    position: relative;
    max-width: 90%;
    max-height: 90%;
}

.lightbox-content img {
    max-width: 100%;
    max-height: 80vh;
    border-radius: 5px;
}

.lightbox-caption {
    color: var(--white);
    text-align: center;
    margin-top: 15px;
    font-size: 1.2rem;
}

.lightbox-close {
    position: absolute;
    top: 20px;
    right: 20px;
    color: var(--white);
    font-size: 2rem;
    cursor: pointer;
}

.lightbox-nav {
    position: absolute;
    top: 50%;
    width: 100%;
    display: flex;
    justify-content: space-between;
    padding: 0 20px;
    transform: translateY(-50%);
}

.lightbox-nav button {
    background-color: rgba(0, 0, 0, 0.5);
    color: var(--white);
    border: none;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    font-size: 1.5rem;
    cursor: pointer;
    transition: var(--transition);
}

.lightbox-nav button:hover {
    background-color: var(--primary-color);
}

@media (max-width: 768px) {
    .gallery-grid {
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
    }
    
    .lightbox-content img {
        max-height: 60vh;
    }
    
    .lightbox-nav button {
        width: 40px;
        height: 40px;
        font-size: 1.2rem;
    }
}

</style>

    <section class="page-header">
        <h1>Our Gallery</h1>
        <p>Explore our work and projects</p>
    </section>
    
    <section class="gallery-section">
        <div class="gallery-filters">
            <button class="filter-btn active" data-filter="all">All</button>
            <!-- <button class="filter-btn" data-filter="projects">Projects</button>
            <button class="filter-btn" data-filter="team">Team</button>
            <button class="filter-btn" data-filter="events">Events</button> -->
        </div>
        
        <div class="gallery-grid">

        <?php 
        for ($i=1; $i < 38; $i++) { 
            $gallery = "gallery$i.jpg";
            echo '  <!-- Gallery Item 1 -->
            <div class="gallery-item" data-category="projects">
                <img src="assets/images/gallery/'.$gallery.'" alt="Project 1">
                <div class="gallery-overlay">
                    <h3>Project 1</h3>
                    <p>Completed in 2023</p>
                    <a href="assets/images/'.$gallery.'" class="gallery-view" data-lightbox="gallery" data-title="Project "'.$i.'">
                        <i class="fas fa-expand"></i>
                    </a>
                </div>
            </div>';
        }
        
        ?>
           
        
 
        </div>
    </section>

<?php include 'includes/footer.php'; ?>